require 'webrick'
require 'net/http'

class WebServer < WEBrick::HTTPServlet::AbstractServlet
  def do_GET(request, response)
    web_service = WebService.new("http://www.example.org")
    handlers = Handlers.new(web_service)

    status_code, content_type, body = handlers.handle(request.path)

    response.status = status_code
    response['Content-Type'] = content_type
    response.body = body
  end
end

class Handlers
  def initialize(web_service)
    @web_service = web_service
  end

  def handle(path)
    case path
    when "/"
      [200, 'text/plain', 'Witaj, świecie']
    when "/api"
      [201, 'application/json', '{"foo":"bar"}']
    when "/web-service"
      @web_service.proxy
    else
      [404, 'text/plain', 'Nie znaleziono']
    end
  end
end

class WebService
  def initialize(url)
    @uri = URI(url)
  end

  def proxy
    response = Net::HTTP.get_response(@uri)
    [response.code.to_i, response['Content-Type'], response.body]
  end
end

# Ten kod będzie działał tylko po uruchomieniu skryptu bezpośrednio z poziomu
# CLI, ale nie w sytuacji, gdy będzie żądany z poziomu innego pliku.
if __FILE__ == $0
  # Uruchomienie serwera w komputerze lokalnym i nasłuchującego na porcie 8000.
  server = WEBrick::HTTPServer.new :Port => 8000
  server.mount '/', WebServer

  # Zakończenie działania serwera następuje po naciśnięciu klawiszy Ctrl+C.
  trap 'INT' do server.shutdown end

  # Uruchomienie serwera.
  server.start
end
